using System;
using System.Text;
using System.Net;
using System.Net.NetworkInformation;
using System.Net.Sockets;
using System.IO;
using System.Security;
using System.Collections.Specialized;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Net.Mime;
using System.Net.Mail;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Threading;
using System.ComponentModel;
using System.Reflection;

namespace CSharpRecipes
{
    public class Networking
    {
        #region 16.1 Tworzenie serwera TCP	
        public static void WritingTCPServer()
        {
            // patrz projekt ConsoleTCPServer
        }

        #endregion

        #region 16.2 Tworzenie klienta TCP	
        public static void WritingTCPClient()
        {
            // patrz projekt ConsoleTCPClient
        }
        #endregion

        #region 16.3 Symulowanie przetwarzania formularza
        public static void SimulatingFormExecution()
        {
            // Aby mc wykorzysta metod, trzeba utworzy katalog wirtualny
            // na komputerze lokalnym. Katalog powinien zawiera pliki webform1.aspx
            // i webform1.aspx.cs i nosi nazw FormSim.
            Uri uri = new Uri("http://localhost/FormSim/WebForm1.aspx");
            WebClient client = new WebClient();

            // utworzenie serii par nazwa-warto w celu jej wysania
            NameValueCollection collection = new NameValueCollection();

            // dodanie niezbdnych par nazwa-warto do kontenera par
            collection.Add("Identity","foo@bar.com");            
            collection.Add("Item","Books");            
            collection.Add("Quantity","5");            
            Console.WriteLine("adowanie par nazwa-warto do URI {0} ...",
                uri.AbsoluteUri);                        

            // zaadowanie kolekcji NameValueCollection
            byte[] responseArray = client.UploadValues(uri.AbsoluteUri,"POST",collection);
            // dekodowanie i wywietlenie odpowiedzi
            Console.WriteLine("\nOtrzymano odpowied {0}",
                Encoding.ASCII.GetString(responseArray));

        }
        #endregion

        #region 16.4 Pobieranie danych z serwera	
        public static void DownloadingDataFromServer()
        {
            string uri = "http://localhost/mojawitryna/index.aspx";

            // utworzenie klienta
            using (WebClient client = new WebClient())
            {
                // pobranie zawartoci pliku
                Console.WriteLine("Pobieranie {0} " + uri);
                // pobranie strony i zapisanie bajtw
                byte[] bytes;
                try
                {
                    bytes = client.DownloadData(uri);
                }
                catch (WebException we)
                {
                    Console.WriteLine(we.ToString());
                    return;
                }
                // wypisanie kodu HTML
                string page = Encoding.ASCII.GetString(bytes);
                Console.WriteLine(page);

                // rozpoczcie pobierania pliku
                Console.WriteLine("Pobieranie pliku z {0}...\r\n", uri);
                // pobranie pliku i umieszczenie go w pliku tymczasowym
                string tempFile = Path.GetTempFileName();
                try
                {
                    client.DownloadFile(uri, tempFile);
                }
                catch (WebException we)
                {
                    Console.WriteLine(we.ToString());
                    return;
                }
                Console.WriteLine("Pobrano plik {0} i umieszczono w {1}", uri, tempFile);
            }
        }
        #endregion

        #region 16.5 Komunikacja przy uyciu potokw nazwanych
        // patrz projekty NamedPipeClientConsole, NamedPipeServerConsole i NamedPipeInteropLibrary
        #endregion

        #region  16.6 Pingowanie z poziomu kodu rdowego
        public static void TestPing()
        {
            System.Net.NetworkInformation.Ping pinger =
                new System.Net.NetworkInformation.Ping();
            PingReply reply = pinger.Send("www.helion.pl");
            DisplayPingReplyInfo(reply);

            pinger.PingCompleted += new PingCompletedEventHandler(pinger_PingCompleted);
            pinger.SendAsync("www.helion.pl", "ping Helion");
        }

        private static void DisplayPingReplyInfo(PingReply reply)
        {
            Console.WriteLine("Wyniki pingowania " + reply.Address);
            Console.WriteLine("\tDozwolona fragmentacja?: {0}", reply.Options.DontFragment);
            Console.WriteLine("\tCzas ycia: {0}", reply.Options.Ttl);
            Console.WriteLine("\tCzas komunikacji: {0}", reply.RoundtripTime);
            Console.WriteLine("\tStatus: {0}", reply.Status.ToString());
        }

        private static void pinger_PingCompleted(object sender, PingCompletedEventArgs e)
        {
            PingReply reply = e.Reply;
            DisplayPingReplyInfo(reply);

            if(e.Cancelled)
            {
                Console.WriteLine("Pingowanie " + e.UserState.ToString() + " zostao anulowane");
            }
            else if (e.Error != null)
            {
                Console.WriteLine("W trakcie pingowania wystpi wyjtek: {0}", e.Error.ToString());
            }
        }

		#endregion

        #region  16.7 Wysyanie poczty SMTP przy uyciu usugi SMTP
        public static void TestSendMail()
        {
            try
            {
                // wysanie wiadomoci z zacznikiem
                string from = "hilyard@comcast.net";
                string to = "hilyard@comcast.net";
                MailMessage attachmentMessage = new MailMessage(from, to);
                attachmentMessage.Subject = "Cze!";
                attachmentMessage.Body = "Zobacz, jaki fajny kod!";
                // wiele systemw odfiltrowuje kod HTML w przekazywanej poczcie
                attachmentMessage.IsBodyHtml = false;
                // zdefiniowanie zacznika
                string pathToCode = @"..\..\16_Networking.cs";
                Attachment attachment =
                    new Attachment(pathToCode,
                        MediaTypeNames.Application.Octet);
                attachmentMessage.Attachments.Add(attachment);

                // Wykorzystanie lokalnej usugi SMTP.  Dla lokalnej usugi SMTP
                // trzeba skonfigurowa przekazywanie do prawdziwego serwera poczty...
                // W podobny sposb mona skonfigurowa wykorzystanie serwera SMTP
                // dostpnego w sieci.                
                SmtpClient client = new SmtpClient("localhost");
                client.Send(attachmentMessage);
                // albo wysanie tekstu
                MailMessage textMessage = new MailMessage("hilyard@comcast.net",
                                    "hilyard@comcast.net",
                                    "To znowu ja",
                                    "Potrzebujesz pomocy lekarza... Mwienie do siebie to jedno, "+
                                    "ale pisanie kodu wysyajcego poczt to ju powana sprawa...");
                client.Send(textMessage);
            }
            catch (Exception e)
            {
                Debug.WriteLine(e);
                Console.WriteLine(e);
            }
        }
		#endregion

        #region  16.8 Sprawdzanie parametrw dostpu do sieci
        public static void TestNetInfo()
        {
            // podpicie zdarze sieciowych
            NetworkChange.NetworkAddressChanged += new NetworkAddressChangedEventHandler(NetworkChange_NetworkAddressChanged);
            NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(NetworkChange_NetworkAvailabilityChanged);
            DisplayNICInfo();
        }

        private static void DisplayNICInfo()
        {
            // wywietlenie aktualnych parametrw karty sieciowej
            NetworkInterface[] adapters = NetworkInterface.GetAllNetworkInterfaces();
            Console.WriteLine("Informacje o karcie sieciowej:");
            foreach (NetworkInterface n in adapters)
            {
                Console.WriteLine("\tIdentyfikator: {0}", n.Id);
                Console.WriteLine("\tAdres fizyczny (MAC): {0}",n.GetPhysicalAddress().ToString());
                Console.WriteLine("\tOpis: {0}", n.Description);
                Console.WriteLine("\tNazwa: {0}", n.Name);
                Console.WriteLine("\tStatus operacyjny: {0}", n.OperationalStatus.ToString());
                Console.WriteLine("\tTyp interfejsu: {0}", n.NetworkInterfaceType.ToString());
                Console.WriteLine("\tPrdko: {0}", n.Speed);

                IPInterfaceProperties ipProps = n.GetIPProperties();
                DisplayInterfaceProperties(ipProps);
                
            }
            Console.WriteLine("");
        }

        private static void DisplayInterfaceProperties(IPInterfaceProperties props)
        {
            Console.WriteLine("\t\tSufiks Dns: {0}", props.DnsSuffix);
            Console.WriteLine("\t\tAdresy Anycast:");
            foreach (IPAddressInformation ipInfo in props.AnycastAddresses)
            {
                Console.WriteLine("\t\t\t{0}", ipInfo.Address.ToString());
                Console.WriteLine("\t\t\tSpenia wymagania Dns?: {0}", ipInfo.IsDnsEligible);
                Console.WriteLine("\t\t\tPrzejciowe?: {0}", ipInfo.IsTransient);
            }

            Console.WriteLine("\t\tAdresy serwera DHCP:");
            foreach (IPAddress ipAddr in props.DhcpServerAddresses)
            {
                Console.WriteLine("\t\t\t{0}", ipAddr.ToString());
            }

            Console.WriteLine("\t\tAdresy DNS:");
            foreach (IPAddress ipAddr in props.DnsAddresses)
            {
                Console.WriteLine("\t\t\t{0}", ipAddr.ToString());
            }

            Console.WriteLine("\t\tAdresy bramy:");
            foreach (GatewayIPAddressInformation gatewayIPInfo in props.GatewayAddresses)
            {
                Console.WriteLine("\t\t\t{0}", gatewayIPInfo.Address.ToString());
            }

            Console.WriteLine("\t\tAdresy emisji pojedynczej:");
            foreach (UnicastIPAddressInformation uniIPInfo in props.UnicastAddresses)
            {
                Console.WriteLine("\t\t\tAdres: {0}", uniIPInfo.Address.ToString());
                Console.WriteLine("\t\t\tPreferowana dugo ycia: {0}", uniIPInfo.AddressPreferredLifetime);
                Console.WriteLine("\t\t\tPrawidowa dugo ycia: {0}", uniIPInfo.AddressValidLifetime);
                Console.WriteLine("\t\t\tDugo dzierawy DHCP: {0}", uniIPInfo.DhcpLeaseLifetime);
                Console.WriteLine("\t\t\tPochodzenie prefiksu: {0}", uniIPInfo.PrefixOrigin.ToString());
                Console.WriteLine("\t\t\tPochodzenie sufiksu: {0}", uniIPInfo.SuffixOrigin.ToString());
            }

            Console.WriteLine("\t\tAdresy emisji grupowej:");
            foreach (MulticastIPAddressInformation multiIPInfo in props.MulticastAddresses)
            {
                Console.WriteLine("\t\t\tAdres: {0}", multiIPInfo.Address.ToString());
                Console.WriteLine("\t\t\tPreferowana dugo ycia: {0}", multiIPInfo.AddressPreferredLifetime);
                Console.WriteLine("\t\t\tPrawidowa dugo ycia: {0}", multiIPInfo.AddressValidLifetime);
                Console.WriteLine("\t\t\tDugo dzierawy DHCP: {0}", multiIPInfo.DhcpLeaseLifetime);
                Console.WriteLine("\t\t\tPochodzenie prefiksu: {0}", multiIPInfo.PrefixOrigin.ToString());
                Console.WriteLine("\t\t\tPochodzenie sufiksu: {0}", multiIPInfo.SuffixOrigin.ToString());
            }

            Console.WriteLine("\t\tAdresy serwera WINS:");
            foreach (IPAddress ipAddr in props.WinsServersAddresses)
            {
                Console.WriteLine("\t\t\t{0}", ipAddr.ToString());
            }
            Console.WriteLine("");

        }

        static void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
        {
            if(e.IsAvailable)
                Console.WriteLine("Poczenie sieciowe jest dostpne");
            else
                Console.WriteLine("Poczenie sieciowe jest niedostpne");
        }

        static void NetworkChange_NetworkAddressChanged(object sender, EventArgs e)
        {
            // adres sieciowy si zmieni, wywietlenie nowych informacji
            Console.WriteLine("*** DOSTPNE NOWE INFORMACJE O SIECI *** ");
            DisplayNICInfo();
        }
		#endregion

        #region  16.9 Skanowanie portw komputera przy uyciu gniazd
        public static void TestSockets()
        {
            // zdefiniowanie zakresu portw
            Console.WriteLine("Sprawdzanie portw 1-30 na komputerze lokalnym...");
            CheapoPortScanner cps = new CheapoPortScanner("127.0.0.1",1,30);
            cps.OpenPortFound += new CheapoPortScanner.OpenPortFoundEventHandler(cps_OpenPortFound);
            cps.Scan();
            Console.WriteLine("Znaleziono {0} otwartych portw oraz {1} portw zamknitych",
                    cps.OpenPorts.Count, cps.ClosedPorts.Count);

            // skanowanie caego komputera - peen zakres portw 1-65535
            //cps = new CheapoPortScanner();
            //cps.Scan();
            //cps.ReportToConsole();
        }

        static void cps_OpenPortFound(object sender, CheapoPortScanner.OpenPortEventArgs args)
        {
            Console.WriteLine("Wyniki metody OpenPortFound: port {0} jest otwarty",args.PortNum);
        }

        class CheapoPortScanner
        {
            #region Prywatne stae i skadowe
            const int PORT_MIN_VALUE = 1;
            const int PORT_MAX_VALUE = 65535;

            private int _minPort = PORT_MIN_VALUE;
            private int _maxPort = PORT_MAX_VALUE;
            private List<int> _openPorts = null;
            private List<int> _closedPorts = null;
            private string _host = "127.0.0.1"; // localhost
            #endregion

            #region Zdarzenie
            public class OpenPortEventArgs : EventArgs
            {
                int _portNum;
                public OpenPortEventArgs(int portNum) : base()
                {
                    _portNum = portNum;
                }

                public int PortNum
                {
                    get { return _portNum; }
                }
            }

            public delegate void OpenPortFoundEventHandler(object sender, OpenPortEventArgs args);
            public event OpenPortFoundEventHandler OpenPortFound;
            #endregion // Zdarzenie

            #region CTOR i kod inicjujcy
            public CheapoPortScanner()
            {
                // dla portw i komputera lokalnego zdefiniowano ju ustawienia domylne
                SetupLists();
            }

            public CheapoPortScanner(string host, int minPort, int maxPort)
            {
                if (minPort > maxPort)
                    throw new ArgumentException("Port o numerze najniszym nie moe by wikszy ni port o numerze najwyszym");
                if (minPort < PORT_MIN_VALUE || minPort > PORT_MAX_VALUE)
                    throw new ArgumentOutOfRangeException("Port o numerze najniszym nie moe by mniejszy ni " +
                                        PORT_MIN_VALUE + " ani wikszy ni " + PORT_MAX_VALUE);
                if (maxPort < PORT_MIN_VALUE || maxPort > PORT_MAX_VALUE)
                    throw new ArgumentOutOfRangeException("Port o numerze najwyszym nie moe by mniejszy ni " +
                                        PORT_MIN_VALUE + " ani wikszy ni " + PORT_MAX_VALUE);

                _host = host;
                _minPort = minPort;
                _maxPort = maxPort;
                SetupLists();
            }

            private void SetupLists()
            {
                // zdefiniowanie list przechowujcych poow zakresu,
                // poniewa nie wiadomo, ile portw bdzie otwartych;
                // rozmiar listy pozwoli wic przechowa poow portw

                // rangeCount ma warto max - min + 1
                int rangeCount = (_maxPort - _minPort) + 1;
                // jeli liczba jest nieparzysta, zwikszenie o jeden, by uzyska dodatkowe jedno miejscebump by one to get one extra slot
                if (rangeCount % 2 != 0)
                    rangeCount += 1;
                // zarezerwowanie poowy portw z kadego zakresu
                _openPorts = new List<int>(rangeCount / 2);
                _closedPorts = new List<int>(rangeCount / 2);
            }
            #endregion // CTOR i kod inicjujcy

            #region Waciwoci
            public ReadOnlyCollection<int> OpenPorts
            {
                get { return new ReadOnlyCollection<int>(_openPorts); } 
            }

            public ReadOnlyCollection<int> ClosedPorts
            {
                get { return new ReadOnlyCollection<int>(_closedPorts); }
            }
            #endregion // Waciwoci

            #region Metody prywatne
            private void CheckPort(int port)
            {
                if (IsPortOpen(port))
                {
                    // jeli tu dotarlimy, oznacza to, e port jest otwarty
                    _openPorts.Add(port);

                    // wysanie informacji do wszystkich zainteresowanych
                    OpenPortFoundEventHandler openPortFound = OpenPortFound;
                    if (openPortFound != null)
                        openPortFound(this, new OpenPortEventArgs(port));
                }
                else
                {
                    // port serwera jest zamknity
                    _closedPorts.Add(port);
                }
            }

            private bool IsPortOpen(int port)
            {
                Socket sock = null;
                try
                {
                    // utworzenie gniazda TCP
                    sock = new Socket(AddressFamily.InterNetwork,
                                    SocketType.Stream,
                                    ProtocolType.Tcp);
                    // poczenie 
                    sock.Connect(_host, port);
                    return true;

                }
                catch (SocketException se)
                {
                    if (se.SocketErrorCode == SocketError.ConnectionRefused)
                    {
                        return false;
                    }
                    else
                    {
                        // prba dostpu do gniazda zakoczya si niepowodzeniem
                        Debug.WriteLine(se.ToString());
                        Console.WriteLine(se.ToString());
                    }
                }
                finally
                {
                    if (sock != null)
                    {
                        if (sock.Connected)
                            sock.Disconnect(false);
                        sock.Close();
                    }
                }
                return false;
            }
            #endregion

            #region Metody publiczne
            public void Scan()
            {
                for (int port = _minPort; port <= _maxPort; port++)
                {
                    CheckPort(port);
                }
            }

            public void ReportToConsole()
            {
                Console.WriteLine("Skanowanie portw komputera {0}:", _host.ToString());
                Console.WriteLine("\tPort pocztkowy: {0}; Port kocowy: {1}", _minPort, _maxPort);
                Console.WriteLine("\tOtwarte porty:");
                foreach (int port in _openPorts)
                {
                    Console.WriteLine("\t\tPort {0}", port);
                }
                Console.WriteLine("\tPorty zamknite:");
                foreach (int port in _closedPorts)
                {
                    Console.WriteLine("\t\tPort {0}", port);
                }
            }

            #endregion // Metody publiczne
        }

		#endregion

        #region 16.10 Uywanie biecych ustawie poczenia z Internetem
        public static void GetInternetSettings()
        {
            try
            {
                InternetSettingsReader isr = new InternetSettingsReader();
                Console.WriteLine("Biecy adres proxy: {0}", isr.ProxyAddr);
                Console.WriteLine("Biecy port proxy: {0}", isr.ProxyPort);
                Console.WriteLine("Konfiguracja obchodzenia adresw lokalnych: {0}",
                                    isr.BypassLocalAddresses);
                Console.WriteLine("Adresy bdce wyjtkiem dla proxy (obejcie):");
                if (isr.ProxyExceptions != null)
                {
                    foreach (string addr in isr.ProxyExceptions)
                    {
                        Console.WriteLine("\t{0}", addr);
                    }
                }
                Console.WriteLine("Typ poczenia proxy: {0}", isr.ConnectionType.ToString());
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
        }

        public class InternetSettingsReader
        {
            #region Struktury WinInet
            [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
            public struct InternetPerConnOptionList
            {
                public int dwSize;					// rozmiar struktury INTERNET_PER_CONN_OPTION_LIST
                public IntPtr szConnection;			// nazwa poczenia dla opcji ustawiania i odczytu
                public int dwOptionCount;			// liczba opcji ustawiania/odczytu
                public int dwOptionError;			// opcja, ktra spowodowaa bd
                public IntPtr options;
            };

            [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
            public struct InternetConnectionOption
            {
                static readonly int Size;
                public PerConnOption m_Option;
                public InternetConnectionOptionValue m_Value;
                static InternetConnectionOption()
                {
                    InternetConnectionOption.Size = Marshal.SizeOf(typeof(InternetConnectionOption));
                }

                // typy zagniedone
                [StructLayout(LayoutKind.Explicit)]
                public struct InternetConnectionOptionValue
                {
                    // pola
                    [FieldOffset(0)]
                    public System.Runtime.InteropServices.ComTypes.FILETIME m_FileTime;
                    [FieldOffset(0)]
                    public int m_Int;
                    [FieldOffset(0)]
                    public IntPtr m_StringPtr;
                }
            }
            #endregion

            #region Wartoci wyliczeniowe WinInet
            //
            // manifest opcji dla Internet{Query|Set}Option
            //
            //public enum InternetOption
            //{
            //    INTERNET_OPTION_CALLBACK = 1,
            //    INTERNET_OPTION_CONNECT_TIMEOUT = 2,
            //    INTERNET_OPTION_CONNECT_RETRIES = 3,
            //    INTERNET_OPTION_CONNECT_BACKOFF = 4,
            //    INTERNET_OPTION_SEND_TIMEOUT = 5,
            //    INTERNET_OPTION_CONTROL_SEND_TIMEOUT = INTERNET_OPTION_SEND_TIMEOUT,
            //    INTERNET_OPTION_RECEIVE_TIMEOUT = 6,
            //    INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT = INTERNET_OPTION_RECEIVE_TIMEOUT,
            //    INTERNET_OPTION_DATA_SEND_TIMEOUT = 7,
            //    INTERNET_OPTION_DATA_RECEIVE_TIMEOUT = 8,
            //    INTERNET_OPTION_HANDLE_TYPE = 9,
            //    INTERNET_OPTION_LISTEN_TIMEOUT = 11,
            //    INTERNET_OPTION_READ_BUFFER_SIZE = 12,
            //    INTERNET_OPTION_WRITE_BUFFER_SIZE = 13,

            //    INTERNET_OPTION_ASYNC_ID = 15,
            //    INTERNET_OPTION_ASYNC_PRIORITY = 16,

            //    INTERNET_OPTION_PARENT_HANDLE = 21,
            //    INTERNET_OPTION_KEEP_CONNECTION = 22,
            //    INTERNET_OPTION_REQUEST_FLAGS = 23,
            //    INTERNET_OPTION_EXTENDED_ERROR = 24,

            //    INTERNET_OPTION_OFFLINE_MODE = 26,
            //    INTERNET_OPTION_CACHE_STREAM_HANDLE = 27,
            //    INTERNET_OPTION_USERNAME = 28,
            //    INTERNET_OPTION_PASSWORD = 29,
            //    INTERNET_OPTION_ASYNC = 30,
            //    INTERNET_OPTION_SECURITY_FLAGS = 31,
            //    INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT = 32,
            //    INTERNET_OPTION_DATAFILE_NAME = 33,
            //    INTERNET_OPTION_URL = 34,
            //    INTERNET_OPTION_SECURITY_CERTIFICATE = 35,
            //    INTERNET_OPTION_SECURITY_KEY_BITNESS = 36,
            //    INTERNET_OPTION_REFRESH = 37,
            //    INTERNET_OPTION_PROXY = 38,
            //    INTERNET_OPTION_SETTINGS_CHANGED = 39,
            //    INTERNET_OPTION_VERSION = 40,
            //    INTERNET_OPTION_USER_AGENT = 41,
            //    INTERNET_OPTION_END_BROWSER_SESSION = 42,
            //    INTERNET_OPTION_PROXY_USERNAME = 43,
            //    INTERNET_OPTION_PROXY_PASSWORD = 44,
            //    INTERNET_OPTION_CONTEXT_VALUE = 45,
            //    INTERNET_OPTION_CONNECT_LIMIT = 46,
            //    INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT = 47,
            //    INTERNET_OPTION_POLICY = 48,
            //    INTERNET_OPTION_DISCONNECTED_TIMEOUT = 49,
            //    INTERNET_OPTION_CONNECTED_STATE = 50,
            //    INTERNET_OPTION_IDLE_STATE = 51,
            //    INTERNET_OPTION_OFFLINE_SEMANTICS = 52,
            //    INTERNET_OPTION_SECONDARY_CACHE_KEY = 53,
            //    INTERNET_OPTION_CALLBACK_FILTER = 54,
            //    INTERNET_OPTION_CONNECT_TIME = 55,
            //    INTERNET_OPTION_SEND_THROUGHPUT = 56,
            //    INTERNET_OPTION_RECEIVE_THROUGHPUT = 57,
            //    INTERNET_OPTION_REQUEST_PRIORITY = 58,
            //    INTERNET_OPTION_HTTP_VERSION = 59,
            //    INTERNET_OPTION_RESET_URLCACHE_SESSION = 60,
            //    INTERNET_OPTION_ERROR_MASK = 62,
            //    INTERNET_OPTION_FROM_CACHE_TIMEOUT = 63,
            //    INTERNET_OPTION_BYPASS_EDITED_ENTRY = 64,
            //    INTERNET_OPTION_DIAGNOSTIC_SOCKET_INFO = 67,
            //    INTERNET_OPTION_CODEPAGE = 68,
            //    INTERNET_OPTION_CACHE_TIMESTAMPS = 69,
            //    INTERNET_OPTION_DISABLE_AUTODIAL = 70,
            //    INTERNET_OPTION_MAX_CONNS_PER_SERVER = 73,
            //    INTERNET_OPTION_MAX_CONNS_PER_1_0_SERVER = 74,
            //    INTERNET_OPTION_PER_CONNECTION_OPTION = 75
            //    INTERNET_OPTION_DIGEST_AUTH_UNLOAD = 76,
            //    INTERNET_OPTION_IGNORE_OFFLINE = 77,
            //    INTERNET_OPTION_IDENTITY = 78,
            //    INTERNET_OPTION_REMOVE_IDENTITY = 79,
            //    INTERNET_OPTION_ALTER_IDENTITY = 80,
            //    INTERNET_OPTION_SUPPRESS_BEHAVIOR = 81,
            //    INTERNET_OPTION_AUTODIAL_MODE = 82,
            //    INTERNET_OPTION_AUTODIAL_CONNECTION = 83,
            //    INTERNET_OPTION_CLIENT_CERT_CONTEXT = 84,
            //    INTERNET_OPTION_AUTH_FLAGS = 85,
            //    INTERNET_OPTION_COOKIES_3RD_PARTY = 86,
            //    INTERNET_OPTION_DISABLE_PASSPORT_AUTH = 87,
            //    INTERNET_OPTION_SEND_UTF8_SERVERNAME_TO_PROXY = 88,
            //    INTERNET_OPTION_EXEMPT_CONNECTION_LIMIT = 89,
            //    INTERNET_OPTION_ENABLE_PASSPORT_AUTH = 90,

            //    INTERNET_OPTION_HIBERNATE_INACTIVE_WORKER_THREADS = 91,
            //    INTERNET_OPTION_ACTIVATE_WORKER_THREADS = 92,
            //    INTERNET_OPTION_RESTORE_WORKER_THREAD_DEFAULTS = 93,
            //    INTERNET_OPTION_SOCKET_SEND_BUFFER_LENGTH = 94,
            //    INTERNET_OPTION_PROXY_SETTINGS_CHANGED = 95,

            //    INTERNET_OPTION_DATAFILE_EXT = 96,

            //    INTERNET_FIRST_OPTION = INTERNET_OPTION_CALLBACK,
            //    INTERNET_LAST_OPTION = INTERNET_OPTION_DATAFILE_EXT
            //}

            //
            // opcje uywane w strukturze INTERNET_PER_CONN_OPTON
            //
            public enum PerConnOption
            {
                INTERNET_PER_CONN_FLAGS = 1, // Ustawia lub odczytuje typ poczenia. Skadowa Value bdzie zawiera jedn lub wicej wartoci z PerConnFlags 
                INTERNET_PER_CONN_PROXY_SERVER = 2, // Ustawia lub odczytuje cig znakw zawierajcy serwery proxy.  
                INTERNET_PER_CONN_PROXY_BYPASS = 3, // Ustawia lub odczytuje cig znakw zawierajcy adresy URL, dla ktrych serwer proxy nie jest uywany.
                INTERNET_PER_CONN_AUTOCONFIG_URL = 4//, // Ustawia lub odczytuje cig znakw zawierajcy adres URL skryptu automatycznej konfiguracji.
                //INTERNET_PER_CONN_AUTODISCOVERY_FLAGS = 5, // Sets or retrieves the automatic discovery settings. The Value member will contain one or more of the values from PerConnAutoDiscoveryFlags 
                //INTERNET_PER_CONN_AUTOCONFIG_SECONDARY_URL = 6, // acuch adresw URL automatycznej konfigurcji. Uywany, gdy podstawowy adres URL wskazuje plik INS, ktry ustawia drugi URL automatycznej konfiguracji dla serwera proxy.  
                //INTERNET_PER_CONN_AUTOCONFIG_RELOAD_DELAY_MINS = 7, // Liczba minut, po ktrej nastpuje automatyczne odwieenie adresu URL automatycznej konfiguracji.
                //INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_TIME = 8, // Opcja tylko do odczytu. Zwraca czas, ktry min od ostatniego odnalezienia prawidowego URL automatycznej konfiguracji.
                //INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_URL = 9  // Opcja tylko do odczytu. Zwraca ostatni znany prawidowy adres URL automatycznej konfiguracji.
            }

            //
            // PER_CONN_FLAGS
            //
            [Flags]
            public enum PerConnFlags
            {
                PROXY_TYPE_DIRECT = 0x00000001,  // bezporednio do sieci
                PROXY_TYPE_PROXY = 0x00000002,  // za porednictwem nazwanego serwera proxy
                PROXY_TYPE_AUTO_PROXY_URL = 0x00000004,  // URL autoproxy
                PROXY_TYPE_AUTO_DETECT = 0x00000008   // uycie automatycznego wykrywania proxy
            }

            ////
            //// PER_CONN_AUTODISCOVERY_FLAGS
            ////
            //[Flags]
            //public enum PerConnAutoDiscoveryFlags
            //{
            //    AUTO_PROXY_FLAG_USER_SET = 0x00000001,   // uytkownik zmieni to ustawienie
            //    AUTO_PROXY_FLAG_ALWAYS_DETECT = 0x00000002,   // wymuszenie rozpoznawania, nawet jeli nie jest wymagane
            //    AUTO_PROXY_FLAG_DETECTION_RUN = 0x00000004,   // uruchomiono rozpoznawanie
            //    AUTO_PROXY_FLAG_MIGRATED = 0x00000008,   // wykonano migracj
            //    AUTO_PROXY_FLAG_DONT_CACHE_PROXY_RESULT = 0x00000010,   // bez zapisu wynikw host=nazwa proxy w pamici podrcznej
            //    AUTO_PROXY_FLAG_CACHE_INIT_RUN = 0x00000020,   // bez inicjacji do momentu wyganicia adresu URL
            //    AUTO_PROXY_FLAG_DETECTION_SUSPECT = 0x00000040   // jeli tylko LAN & Modem z jednym adresem IP, to bd?!?
            //}
            #endregion

            #region Definicje P/Invoke
            [DllImport("WinInet.dll", EntryPoint = "InternetQueryOptionW", CharSet = CharSet.Auto, SetLastError = true)]
            public static extern bool InternetQueryOption(
                IntPtr hInternet,
                int dwOption,
                ref InternetPerConnOptionList optionsList,
                ref int bufferLength
                );
            #endregion

            #region Skadowe prywatne
            string _proxyAddr = "";
            int _proxyPort = -1;
            bool _bypassLocal = false;
            string _autoConfigAddr = "";
            string[] _proxyExceptions = null;
            PerConnFlags _flags;
            #endregion

            #region CTOR
            public InternetSettingsReader()
            {
            }
            #endregion

            #region Waciwoci
            public string ProxyAddr
            {
                get
                {
                    InternetConnectionOption ico = 
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_PROXY_SERVER);
                    // parsowanie adresu i portu
                    string proxyInfo = Marshal.PtrToStringUni(
                                            ico.m_Value.m_StringPtr);
                    ParseProxyInfo(proxyInfo);
                    return _proxyAddr;
                }
            }
            public int ProxyPort
            {
                get
                {
                    InternetConnectionOption ico = 
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_PROXY_SERVER);
                    // parsowanie adresu i portu
                    string proxyInfo = Marshal.PtrToStringUni(
                                            ico.m_Value.m_StringPtr);
                    ParseProxyInfo(proxyInfo);
                    return _proxyPort;
                }
            }
            public bool BypassLocalAddresses
            {
                get 
                {
                    InternetConnectionOption ico =
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_PROXY_BYPASS);
                    // obejcia s oznaczane jako <local> na licie wyjtkw
                    string exceptions = 
                        Marshal.PtrToStringUni(ico.m_Value.m_StringPtr);

                    if (exceptions.IndexOf("<local>") != -1)
                        _bypassLocal = true;
                    else
                        _bypassLocal = false;
                    return _bypassLocal; 
                }
            }
            public string AutoConfigurationAddr
            {
                get 
                {
                    InternetConnectionOption ico =
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_AUTOCONFIG_URL);
                    // najprostszy sposb
                    _autoConfigAddr = 
                        Marshal.PtrToStringUni(ico.m_Value.m_StringPtr);
                    if (_autoConfigAddr == null)
                        _autoConfigAddr = "";
                    return _autoConfigAddr; 
                }
            }
            public string[] ProxyExceptions
            {
                get 
                {
                    InternetConnectionOption ico =
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_PROXY_BYPASS);
                    // wyjtki s oddzielane od siebie znakiem rednika
                    string exceptions = 
                        Marshal.PtrToStringUni(ico.m_Value.m_StringPtr);
                    if (!string.IsNullOrEmpty(exceptions))
                    {
                        _proxyExceptions = exceptions.Split(';');
                    }
                    return _proxyExceptions; 
                }
            }
            public PerConnFlags ConnectionType
            {
                get 
                {
                    InternetConnectionOption ico =
                        GetInternetConnectionOption(
                            PerConnOption.INTERNET_PER_CONN_FLAGS);
                    _flags = (PerConnFlags)ico.m_Value.m_Int;

                    return _flags; 
                }
            }

            #endregion

            #region Metody prywatne
            private void ParseProxyInfo(string proxyInfo)
            {
                if(!string.IsNullOrEmpty(proxyInfo))
                {
                    string [] parts = proxyInfo.Split(':');
                    if (parts.Length == 2)
                    {
                        _proxyAddr = parts[0];
                        try
                        {
                            _proxyPort = Convert.ToInt32(parts[1]);
                        }
                        catch (FormatException)
                        {
                            // nie ma portu
                            _proxyPort = -1;
                        }
                    }
                    else 
                    {
                        _proxyAddr = parts[0];
                        _proxyPort = -1;
                    }
                }
            }

            private InternetConnectionOption GetInternetConnectionOption(PerConnOption pco)
            {
                // alokacja listy i opcji
                InternetPerConnOptionList perConnOptList = new InternetPerConnOptionList();
                InternetConnectionOption ico = new InternetConnectionOption();
                // podpicie struktury opcji
                GCHandle gch = GCHandle.Alloc(ico, GCHandleType.Pinned);
                // zainicjowanie opcji dla podanych danych
                ico.m_Option = pco;
                // zainicjowanie listy opcji dla poczenia domylnego lub LAN
                int listSize = Marshal.SizeOf(perConnOptList);
                perConnOptList.dwSize = listSize;
                perConnOptList.szConnection = IntPtr.Zero;
                perConnOptList.dwOptionCount = 1;
                perConnOptList.dwOptionError = 0;
                // ustalenie rozmiarw i przesuni
                int icoSize = Marshal.SizeOf(ico);
                int optionTotalSize = icoSize;
                // alokowanie odpowiedniej iloci pamici dla opcji
                perConnOptList.options =
                    Marshal.AllocCoTaskMem(icoSize);

                long icoOffset = (long)perConnOptList.options + (long)icoSize;
                // utworzenie wskanika struktury
                IntPtr optionListPtr = perConnOptList.options;
                Marshal.StructureToPtr(ico, optionListPtr, false);

                // utworzenie zapytania
                if (InternetQueryOption(
                    IntPtr.Zero,
                    75, //(int)InternetOption.INTERNET_OPTION_PER_CONNECTION_OPTION,
                    ref perConnOptList,
                    ref listSize) == true)
                {
                    // odczytanie wartoci
                    ico =
                        (InternetConnectionOption)Marshal.PtrToStructure(perConnOptList.options,
                                                typeof(InternetConnectionOption));
                }
                // zwolnienie pamici COM
                Marshal.FreeCoTaskMem(perConnOptList.options);
                // odczenie struktur
                gch.Free();

                return ico;
            }
            #endregion
        }

		#endregion

        #region 16.11 Pobieranie pliku za porednictwem FTP
        public static void TestFTPDownload()
        {
            try
            {
                // pobranie kodu rdowego
                FtpWebRequest request =
                    (FtpWebRequest)WebRequest.Create(
                    "ftp://ftp.oreilly.com/pub/examples/csharpckbk/CSharpCookbook.zip");

                request.Credentials = new NetworkCredential("anonymous", "hilyard@oreilly.com");
                using (FtpWebResponse response = (FtpWebResponse)request.GetResponse())
                {
                    Stream data = response.GetResponseStream();
                    string targetPath = "CSharpCookbook.zip";
                    if (File.Exists(targetPath))
                        File.Delete(targetPath);

                    byte[] byteBuffer = new byte[4096];
                    using (FileStream output = new FileStream(targetPath, FileMode.CreateNew))
                    {
                        int bytesRead = 0;
                        do
                        {
                            bytesRead = data.Read(byteBuffer, 0, byteBuffer.Length);
                            if (bytesRead > 0)
                            {
                                output.Write(byteBuffer, 0, bytesRead);
                            }
                        }
                        while (bytesRead > 0);
                    }
                }
            }
            catch (WebException e)
            {
                Console.WriteLine(e);
            }
        }

        public static void ResumeFtpFileDownload(Uri sourceUri, string destinationFile)
        {
            FileInfo file = new FileInfo(destinationFile);
            FileStream localfileStream;
            FtpWebRequest request = WebRequest.Create(sourceUri) as FtpWebRequest;
            request.Method = WebRequestMethods.Ftp.DownloadFile;
            if (file.Exists)
            {
                request.ContentOffset = file.Length;
                localfileStream = new FileStream(destinationFile, FileMode.Append, FileAccess.Write);
            }
            else
            {
                localfileStream = new FileStream(destinationFile, FileMode.Create, FileAccess.Write);
            }
            WebResponse response = request.GetResponse();
            Stream responseStream = response.GetResponseStream();
            byte[] buffer = new byte[1024];
            int bytesRead = responseStream.Read(buffer, 0, 1024);
            while (bytesRead != 0)
            {
                localfileStream.Write(buffer, 0, bytesRead);
                bytesRead = responseStream.Read(buffer, 0, 1024);
            }
            localfileStream.Close();
            responseStream.Close();
        }
        #endregion
    }
}
